/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package db;

import basics.Human;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author herc
 */
public class Database {

    private static Connection conn;

    public boolean isConnected() {
        try {
            if (conn != null && !conn.isClosed()) {
                return true;
            } else {
                return false;
            }
        } catch (SQLException ex) {
            Logger.getLogger(Database.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    public static void connect() {
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
        } catch (ClassNotFoundException ex) {
            Logger.getLogger(Database.class.getName()).log(Level.SEVERE, null, ex);
        }
        String url = "jdbc:oracle:thin:@//10.100.51.123:1521/orcl";
        try {
            conn = DriverManager.getConnection(url, "test", "test");
        } catch (SQLException ex) {
            Logger.getLogger(Database.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void disconnect() {
        try {
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        } catch (SQLException ex) {
            Logger.getLogger(Database.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void storeHuman(Human h) {
        try {
            Statement st = conn.createStatement();
            String sql = "insert into human values ('" + h.getName() + "'," + h.getAge() + ");";
            System.out.println(sql);
            st.execute(sql);
//            System.out.println(numRows);
            st.close();
        } catch (SQLException ex) {
            Logger.getLogger(Database.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static ArrayList<Human> getAllHumans() {
        ArrayList<Human> all=new ArrayList<Human>();
        try {
            Statement st = conn.createStatement();
            String sql="SELECT * FROM human";
            ResultSet rs=st.executeQuery(sql);
            while (rs.next()){
                Human h=new Human(rs.getString(1),rs.getInt(2));
                all.add(h);
            }
            st.close();
        } catch (SQLException ex) {
            Logger.getLogger(Database.class.getName()).log(Level.SEVERE, null, ex);
        }
        
        return all;
    }

    public static void clearHumans() {
        try {
            Statement st = conn.createStatement();
            String sql="DELETE FROM human";
            st.execute(sql);
//            System.out.println(numRows);
            st.close();
        } catch (SQLException ex) {
            Logger.getLogger(Database.class.getName()).log(Level.SEVERE, null, ex);
        }

        
    }

    public static void storeAllHumans(ArrayList<Human> humans) {
        try {
            PreparedStatement pst = conn.prepareStatement("INSERT INTO human VALUES(?,?)");
            for (Human h : humans) {
                pst.setString(1, h.getName());
                pst.setInt(2, h.getAge());
                pst.addBatch();
            }
            pst.executeBatch();
//            System.out.println(numRows);
            pst.close();
        } catch (SQLException ex) {
            Logger.getLogger(Database.class.getName()).log(Level.SEVERE, null, ex);
        }

    }
}
