/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.hua.filemanagement;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hua.basics.Cloud;

/**
 *
 * @author varlamis
 */
public class CloudFileManager {

    public Cloud readCloudInfoFromRow(String row) {
        Cloud c = new Cloud(row);
        return c;
    }

    public ArrayList<Cloud> readCloudInfoFromFile(String filename) {
        ArrayList<Cloud> all = new ArrayList<Cloud>();
        try {
            BufferedReader br
                    = new BufferedReader(new FileReader(filename));
            String row = br.readLine();
            row = br.readLine();
            while (row != null) {
                Cloud c = readCloudInfoFromRow(row);
                all.add(c);
                row = br.readLine();
            }
            br.close();
        } catch (FileNotFoundException ex) {
            Logger.getLogger(CloudFileManager.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(CloudFileManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        return all;
    }

    public void writeCloudInfoToFile(String filename, ArrayList<Cloud> clouds) {
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(filename));
            for (Cloud cl : clouds) {
                ps.println(cl);
            }
            ps.close();
        } catch (FileNotFoundException ex) {
            Logger.getLogger(CloudFileManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

}
