/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.hua.filemanagement;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.hua.basics.Comment;
import org.json.JSONArray;
import org.json.JSONObject;

/**
 *
 * @author varlamis
 */
public class JsonHandler {

  private String readAll(Reader rd) throws IOException {
    StringBuilder sb = new StringBuilder();
    int cp;
    while ((cp = rd.read()) != -1) {
      sb.append((char) cp);
    }
    return sb.toString();
  }
    
    public ArrayList<Comment> getCommentsFor(String postid) throws MalformedURLException, IOException {
        ArrayList<Comment> all = new ArrayList<Comment>();

        InputStream is = 
          new URL("https://jsonplaceholder.typicode.com/posts/"+postid+
                  "/comments").openStream();
        try {
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            String jsonText = readAll(rd);
            JSONArray json = new JSONArray(jsonText);
            for (int i=0;i<json.length();i++){
                JSONObject j=json.getJSONObject(i);
                String id=j.getInt("id")+"";
                String name=j.getString("name");
                String email=j.getString("email");
                Comment c=new Comment(id,name,email);
                all.add(c);
            }
        } finally {
            is.close();
        }
        return all;
    }
}
