package gr.hua.dit.oop2.project1;

import gr.hua.dit.oop2.project1.basics.Route;
import gr.hua.dit.oop2.project1.basics.Stop;
import gr.hua.dit.oop2.project1.basics.Stoptime;
import gr.hua.dit.oop2.project1.basics.Trip;
import gr.hua.dit.oop2.project1.filemanagement.FileManager;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author Christos Sardianos <sardianos@hua.gr>
 */
public class Demo {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        //Read Routes
        String routesFilename = "files/geodata/routes.txt";
        ArrayList<Route> routes = new ArrayList<>();
        try {
            BufferedReader br1 = new BufferedReader(new InputStreamReader(new FileInputStream(routesFilename), "UTF8"));
            String row = br1.readLine();
            row = br1.readLine();
            while (row != null) {
                FileManager fl = new FileManager();
                Route r = fl.getRouteFromString(row);
                routes.add(r);
                row = br1.readLine();
            }
            br1.close();
            Oasa.setAllRoutes(routes);
        } catch (FileNotFoundException ex) {
            Logger.getLogger(FileManager.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(FileManager.class.getName()).log(Level.SEVERE, null, ex);
        }

        //Read Trips
        String tripsFilename = "files/geodata/trips.txt";
        ArrayList<Trip> trips = new ArrayList<>();
        try {
            BufferedReader br2 = new BufferedReader(new InputStreamReader(new FileInputStream(tripsFilename), "UTF8"));
            String row = br2.readLine();
            row = br2.readLine();
            while (row != null) {
                FileManager fl = new FileManager();
                Trip t = fl.getTripFromString(row);
                trips.add(t);
                row = br2.readLine();
            }
            br2.close();
            Oasa.setAllTrips(trips);
        } catch (FileNotFoundException ex) {
            Logger.getLogger(FileManager.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(FileManager.class.getName()).log(Level.SEVERE, null, ex);
        }

        //Read Stops
        String stopsFilename = "files/geodata/stops.txt";
        ArrayList<Stop> stops = new ArrayList<>();
        try {
            BufferedReader br3 = new BufferedReader(new InputStreamReader(new FileInputStream(stopsFilename), "UTF8"));
            String row = br3.readLine();
            row = br3.readLine();
            while (row != null) {
                FileManager fl = new FileManager();
                Stop s = fl.getStopFromString(row);
                stops.add(s);
                row = br3.readLine();
            }
            br3.close();
            Oasa.setAllStops(stops);
        } catch (FileNotFoundException ex) {
            Logger.getLogger(FileManager.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(FileManager.class.getName()).log(Level.SEVERE, null, ex);
        }

        //Find stops for each trip
        String stop_timesFilename = "files/geodata/stop_times.txt";
        ArrayList<Stoptime> stoptimes = new ArrayList<>();
        try {
            BufferedReader br4 = new BufferedReader(new InputStreamReader(new FileInputStream(stop_timesFilename), "UTF8"));
            String row = br4.readLine();
            row = br4.readLine();
            while (row != null) {
                FileManager fl = new FileManager();
                Stoptime stt = fl.getStopTimeFromString(row);
                stoptimes.add(stt);
                row = br4.readLine();
            }
            br4.close();
        } catch (FileNotFoundException ex) {
            Logger.getLogger(FileManager.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(FileManager.class.getName()).log(Level.SEVERE, null, ex);
        }

        for (Trip eachTrip : Oasa.allTrips) {
            String eachTripId = eachTrip.getTrip_id();
//            ArrayList<Stop> eachTripStops = eachTrip.getStops();
            for (Stoptime stop_time : stoptimes) {
                if (eachTripId.equals(stop_time.getTrip_id())) {
                    String stop_id_to_look_for = stop_time.getStop_id();
//                    String stop_sequence = stop_time.getStop_sequence();
                    for (Stop currentStopSearched : Oasa.allStops) {
                        if (currentStopSearched.getStop_id().equals(stop_id_to_look_for)) {
                            eachTrip.addStop(currentStopSearched);
//                            eachTripStops.add(currentStopSearched);
                        }
                    }
                }

            }
        }
        
        System.out.println(Oasa.allTrips.size());
        for (Trip eachTrip : Oasa.allTrips) {
            System.out.println("__________");
            System.out.println("##" + eachTrip.getTrip_id() + "::" + eachTrip.getTrip_headsign());
            for (Stop st : eachTrip.getStops()) {
                System.out.println(st.getStop_id() + "::" + st.getStop_name() + "::" + st.getStop_desc());
            }
        }

    }

}
