package gr.hua.dit.oop2.project1.filemanagement;

import gr.hua.dit.oop2.project1.Oasa;
import gr.hua.dit.oop2.project1.basics.Route;
import gr.hua.dit.oop2.project1.basics.Stop;
import gr.hua.dit.oop2.project1.basics.Stoptime;
import gr.hua.dit.oop2.project1.basics.Trip;

/**
 *
 * @author Christos Sardianos <sardianos@hua.gr>
 */
public class FileManager {

    public Route getRouteFromString(String row) {
        String[] rowTokens = row.split(",");
        String route_id = rowTokens[0];
        String route_short_name = rowTokens[1];
        String route_long_name = rowTokens[2];
        Integer route_type = Integer.parseInt(rowTokens[4]);
        String route_color = rowTokens[5];
        String route_text_color = rowTokens[6];

        Route ro = new Route(route_id, route_short_name, route_long_name, route_type, route_color, route_text_color);
        return ro;
    }

    public Trip getTripFromString(String row) {
        String[] rowTokens = row.split(",");
        String route_id = rowTokens[0];
        String service_id = rowTokens[1];
        String trip_id = rowTokens[2];
        String trip_headsign = rowTokens[3];

        Trip tr = null;
//        for (Route curRoute : Oasa.allRoutes) {
//            if (curRoute.getRoute_id().equals(route_id)) {
//                tr = new Trip(service_id, trip_id, trip_headsign, curRoute);
//            }
//        }
        Route curRoute=Oasa.allRoutesMap.get(route_id);
        tr = new Trip(service_id, trip_id, trip_headsign, curRoute);
        return tr;
    }

    public Stop getStopFromString(String row) {
        String[] rowTokens = row.split(",");
        String stop_id = rowTokens[0];
        String stop_code = rowTokens[1];
        String stop_name = rowTokens[2];
        String stop_desc = rowTokens[3];
        String stop_lat = rowTokens[4];
        String stop_lon = rowTokens[5];

        Stop st = new Stop(stop_id, stop_code, stop_name, stop_desc, stop_lat, stop_lon);
        return st;
    }

    public Stoptime getStopTimeFromString(String row) {
        String[] rowTokens = row.split(",");
        String trip_id = rowTokens[0];
        String stop_id = rowTokens[1];
        String stop_sequence = rowTokens[2];

        Stoptime stt = new Stoptime(trip_id, stop_id, stop_sequence);
        return stt;
    }
}
