/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gr.hua.dit.oop2.project1.NYT;

import gr.hua.dit.oop2.project1.NYT.basics.Article;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

/**
 *
 * @author varlamis
 */
public class NYTimesThreaded
        implements Runnable {

    String apiUrl = "https://api.nytimes.com/svc/search/v2/articlesearch.json";
    String apiKey = "f812fa3556e745639e378dfc9f7b4fda";
    String queryParam = "obama";
    String fromDate, toDate;
    boolean finished;
    ArrayList<Article> NewYorkTimes_articles;

    public NYTimesThreaded(String fromDate, String toDate, 
            ArrayList<Article> all) {
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.NewYorkTimes_articles = all;
        finished=false;
//        String fromDate = "20180422";
//        String toDate = "20180423";

    }

    public void run() {
        try {
            System.out.println("Testing 1 - Send Http GET request");
            String url = apiUrl + "?api-key=" + apiKey
                    + "&q=" + queryParam + "&begin_date=" + fromDate
                    + "&end_date=" + toDate;
            System.out.println(url);

            HttpClient client = HttpClientBuilder.create().build();
            HttpGet request = new HttpGet(url);
            request.addHeader("User-Agent", "Mozilla/5.0");
            HttpResponse response = client.execute(request);

            // add request header
//            System.out.println("\nSending 'GET' request to URL : " + url);
//            System.out.println("Response Code : " + response.getStatusLine().getStatusCode());

            InputStream contentResponse = response.getEntity().getContent();

            JSONParser jp = new JSONParser();
            JSONObject jsonObject = (JSONObject) jp.parse(
                    new InputStreamReader(contentResponse, "UTF-8"));
//            System.out.println(jsonObject.get("response"));

            JSONObject responseValueInJSON = (JSONObject) jsonObject.get("response");
            JSONArray docs = (JSONArray) responseValueInJSON.get("docs");

            for (Iterator it = docs.iterator(); it.hasNext();) {
                JSONObject article = (JSONObject) it.next();
                String id = (String) article.get("_id");
                String snippet = (String) article.get("snippet");
                JSONObject headline = (JSONObject) article.get("headline");
                String mainTitle = (String) headline.get("main");
                String pubDate = (String) article.get("pub_date");
                Long wordCount = (Long) article.get("word_count");
                Article curArticle = new Article(id, snippet, mainTitle, pubDate, wordCount);
//                System.out.println(curArticle);
//                System.out.println("-----");

                NewYorkTimes_articles.add(curArticle);
            }

        } catch (Exception ex) {
            Logger.getLogger(DemoMain.class.getName()).log(Level.SEVERE, null, ex);
        }
        finished=true;
    }

}
