/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gr.hua.dit.oop2.project1.NYT.api;

import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClientBuilder;

/**
 *
 * @author Christos Sardianos <sardianos@hua.gr>
 */
public class ApiCaller {

    /**
     * NYT API: http://developer.nytimes.com/
     * http://developer.nytimes.com/article_search_v2.json
     *
     */
    private final String USER_AGENT = "Mozilla/5.0";

    // HTTP GET request
    public InputStream sendGet(String apiEndPoint, String apiKey, String queryParam, String beginDate, String endDate) throws Exception {

        String url = apiEndPoint + "?api-key=" + apiKey + "&q=" + queryParam + "&begin_date=" + beginDate + "&end_date=" + endDate;
        
        HttpClient client = HttpClientBuilder.create().build();
        HttpGet request = new HttpGet(url);
        HttpResponse response = client.execute(request);
        
        // add request header
        request.addHeader("User-Agent", USER_AGENT);

        System.out.println("\nSending 'GET' request to URL : " + url);
        System.out.println("Response Code : " + response.getStatusLine().getStatusCode());

        InputStream contentResponse = response.getEntity().getContent();
        
        //Παράδειγμα εκτύπωσης του response από το API
//        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
//
//        StringBuffer result = new StringBuffer();
//        String line = "";
//        while ((line = rd.readLine()) != null) {
//            result.append(line);
//        }
//
//        System.out.println(result.toString());

        return contentResponse;

    }
}
