from pox.core import core # Central point for POX APIs
import pox.openflow.libopenflow_01 as of # Import OpenFlow 1.0 module and rename it "of"

log = core.getLogger() # Display messages

def _handle_PacketIn (event): # Handler function which specifies what to do when PacketIn happens
  packet=event.parsed # Extract Ethernet frame from event
  msg = of.ofp_flow_mod() # Create an instruction "msg" which will be used for adding flow table entry into device later on
  # LAB: FILL THE PARENTHESIS IN THE NEXT LINE:
  msg.actions.append(____________________) # Specify flood action
  event.connection.send(msg) # Send the instruction to device

def launch (): # Is used for initializing POX component
  core.openflow.addListenerByName("PacketIn", _handle_PacketIn) # Specify handler function when PacketIn occurs
  log.info("Hub application is running.") # Display messages

